
import gurobipy as gp

# Create a new model
model = gp.Model("cocktail_mix")

# Create variables
white_cocktail = model.addVar(lb=0, name="white_cocktail")  # kg of white cocktail
green_cocktail = model.addVar(lb=0, name="green_cocktail")  # kg of green cocktail

# Set objective function: Minimize cost
model.setObjective(5.5 * white_cocktail + 12 * green_cocktail, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(0.07 * white_cocktail + 0.02 * green_cocktail >= 5, "alcohol_constraint")
model.addConstr(0.10 * white_cocktail + 0.25 * green_cocktail >= 25, "sugar_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"White cocktail: {white_cocktail.x:.2f} kg")
    print(f"Green cocktail: {green_cocktail.x:.2f} kg")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

