
from gurobipy import *

# Create a new model
m = Model("Cocktail_Mixing")

# Define variables
x1 = m.addVar(name="white_cocktail", lb=0)
x2 = m.addVar(name="green_cocktail", lb=0)

# Set the objective function
m.setObjective(5.5*x1 + 12*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.07*x1 + 0.02*x2 >= 5, name="alcohol_constraint")
m.addConstr(0.10*x1 + 0.25*x2 >= 25, name="sugar_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Amount of white cocktail: {x1.x}")
    print(f"Amount of green cocktail: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found.")
