
import gurobipy as gp

# Create a new model
m = gp.Model("Cocktail_Mixing")

# Define variables
x1 = m.addVar(name="white_cocktail", lb=0)  # Amount of white cocktail
x2 = m.addVar(name="green_cocktail", lb=0)  # Amount of green cocktail

# Objective function: minimize cost
m.setObjective(5.5 * x1 + 12 * x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(0.07 * x1 + 0.02 * x2 >= 5, name="alcohol_constraint")
m.addConstr(0.10 * x1 + 0.25 * x2 >= 25, name="sugar_constraint")

# Solve the model
m.solve()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Amount of white cocktail: {x1.varValue} kg")
    print(f"Amount of green cocktail: {x2.varValue} kg")
    print(f"Minimum cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
