
from gurobipy import *

# Create a new model
m = Model("Iota_Software")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="full_time_employees")
x2 = m.addVar(vtype=GRB.INTEGER, name="part_time_employees")

# Set the objective function
m.setObjective(800*x1 + 400*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x2 >= 60, "total_employees")
m.addConstr(x1 >= 40, "full_time_min")
m.addConstr(x1 >= (1/3)*x2, "full_time_vs_part_time")
m.addConstr(800*x1 + 400*x2 <= 30000, "wage_bill")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Full-time employees: {x1.x}")
    print(f"Part-time employees: {x2.x}")
    print(f"Wage bill: ${800*x1.x + 400*x2.x}")
else:
    print("No optimal solution found.")
