
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="full-time_employees", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=0, name="part-time_employees", vtype=gurobi.GRB.INTEGER)

    # Objective function: minimize 800*x1 + 400*x2
    model.setObjective(800*x1 + 400*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 + x2 >= 60, name="total_employees")
    model.addConstr(x1 >= 40, name="min_full-time_employees")
    model.addConstr(x1 >= (1/3)*x2, name="full-time_to_part-time_ratio")
    model.addConstr(800*x1 + 400*x2 <= 30000, name="wage_bill")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Full-time employees: {x1.varValue}")
        print(f"Part-time employees: {x2.varValue}")
        print(f"Minimum wage bill: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
