
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("James_Flower_Profit")

# Create variables
x1 = m.addVar(lb=0, name="aster_flowers_sqft")  # Aster flowers square footage
x2 = m.addVar(lb=0, name="stonecrops_sqft")  # Stonecrops square footage


# Set objective function: Maximize profit
m.setObjective(60*x1 + 80*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 120, "total_area")  # Total area constraint
m.addConstr(20*x1 + 45*x2 <= 5000, "budget")  # Budget constraint


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
    m.computeIIS()  # Compute Irreducible Inconsistent Subsystem
    m.write("model.ilp") # Write the model to a file
    print("IIS written to file 'model.ilp'")
else:
    # Print optimal solution
    print("\nOptimal Solution:")
    print(f"Aster flowers square footage: {x1.x}")
    print(f"Stonecrops square footage: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")

