
from gurobipy import *

# Create a new model
m = Model("James_Planting_Problem")

# Define variables
x1 = m.addVar(lb=0, name="aster_flowers_area")
x2 = m.addVar(lb=0, name="stonecrops_area")

# Set the objective function
m.setObjective(60*x1 + 80*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 120, "total_area_constraint")
m.addConstr(20*x1 + 45*x2 <= 5000, "budget_constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Aster flowers area: {x1.x} square feet")
    print(f"Stonecrops area: {x2.x} square feet")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found.")
