
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="aster_flowers_area")
    x2 = model.addVar(lb=0, name="stonecrops_area")

    # Define the objective function
    model.setObjective(60*x1 + 80*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 120, name="total_area_constraint")
    model.addConstr(20*x1 + 45*x2 <= 5000, name="budget_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Aster flowers area: {x1.varValue}")
        print(f"Stonecrops area: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
