
import gurobipy as gp

# Create a new model
m = gp.Model("car_production")

# Create variables
suv = m.addVar(vtype=gp.GRB.CONTINUOUS, name="suv")  # Number of SUVs
sedan = m.addVar(vtype=gp.GRB.CONTINUOUS, name="sedan")  # Number of sedans


# Set objective function
m.setObjective(10000 * suv + 9000 * sedan, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(200 * suv + 150 * sedan <= 20000, "manufacturing_constraint")
m.addConstr(120 * suv + 100 * sedan <= 10000, "testing_constraint")
m.addConstr(suv >= 0, "suv_nonnegativity")
m.addConstr(sedan >= 0, "sedan_nonnegativity")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of SUVs to produce: {suv.x}")
    print(f"Number of Sedans to produce: {sedan.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

