
from gurobipy import *

# Create a new model
m = Model("Car_Production")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="SUVs", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Sedans", lb=0)

# Set the objective function
m.setObjective(10000*x1 + 9000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(200*x1 + 150*x2 <= 20000, "Manufacturing_Time")
m.addConstr(120*x1 + 100*x2 <= 10000, "Testing_Time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of SUVs: {x1.x}")
    print(f"Number of Sedans: {x2.x}")
    print(f"Maximum Profit: ${10000*x1.x + 9000*x2.x:.2f}")
else:
    print("No optimal solution found")
