
import gurobipy as gp

# Create a new model
model = gp.Model("Car_Production")

# Define variables
x1 = model.addVar(name="SUVs", lb=0, vtype=gp.GRB.INTEGER)  # Number of SUVs
x2 = model.addVar(name="sedans", lb=0, vtype=gp.GRB.INTEGER)  # Number of sedans

# Objective function: Maximize profit
model.setObjective(10000*x1 + 9000*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(200*x1 + 150*x2 <= 20000, name="Manufacturing_Time")
model.addConstr(120*x1 + 100*x2 <= 10000, name="Testing_Time")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: SUVs = {x1.varValue}, sedans = {x2.varValue}")
    print(f"Max Profit: ${model.objVal}")
else:
    print("No optimal solution found.")
