
import gurobipy as gp

# Create a new model
model = gp.Model("bag_production")

# Create variables
laptop_bags = model.addVar(vtype=gp.GRB.CONTINUOUS, name="laptop_bags")  # x1
briefcases = model.addVar(vtype=gp.GRB.CONTINUOUS, name="briefcases")  # x2


# Set objective function
model.setObjective(80 * laptop_bags + 50 * briefcases, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(12 * laptop_bags + 10 * briefcases <= 300, "sewing_constraint")
model.addConstr(5 * laptop_bags + 9 * briefcases <= 500, "painting_constraint")
model.addConstr(laptop_bags >= 0, "laptop_bags_nonnegative")
model.addConstr(briefcases >= 0, "briefcases_nonnegative")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Laptop Bags: {laptop_bags.x}")
    print(f"Number of Briefcases: {briefcases.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

