
from gurobipy import *

# Create a new model
m = Model("Bag_Production")

# Define variables
x1 = m.addVar(name="laptop_bags", lb=0)
x2 = m.addVar(name="briefcases", lb=0)

# Set the objective function
m.setObjective(80*x1 + 50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x1 + 10*x2 <= 300, name="sewing_time")
m.addConstr(5*x1 + 9*x2 <= 500, name="painting_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
