
import gurobi

def solve_bag_production():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="laptop_bags", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="briefcases", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: maximize 80*x1 + 50*x2
    model.setObjective(80*x1 + 50*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(12*x1 + 10*x2 <= 300, name="sewing_time")
    model.addConstr(5*x1 + 9*x2 <= 500, name="painting_time")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: laptop bags = {x1.varValue}, briefcases = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_bag_production()
