
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Avian_Advertising")

# Create variables
concert_ads = m.addVar(vtype=GRB.CONTINUOUS, name="concert_ads")
cinema_ads = m.addVar(vtype=GRB.CONTINUOUS, name="cinema_ads")


# Set objective function
m.setObjective(80000 * concert_ads + 30000 * cinema_ads, GRB.MINIMIZE)

# Add constraints
m.addConstr(9000000 * concert_ads + 5000000 * cinema_ads >= 86000000, "young_girls")
m.addConstr(4000000 * concert_ads + 45000000 * cinema_ads >= 72000000, "middle_aged_women")
m.addConstr(concert_ads >= 0)
m.addConstr(cinema_ads >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal}")
    print(f"Number of concert ads: {concert_ads.x}")
    print(f"Number of cinema ads: {cinema_ads.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

