
import gurobipy as gp

# Create a new model
model = gp.Model("Avian_Cosmetics_Advertising")

# Define the variables
x1 = model.addVar(name="concert_ads", lb=0, vtype=gp.GRB.CONTINUOUS)  # number of 1-minute concert ads
x2 = model.addVar(name="cinema_ads", lb=0, vtype=gp.GRB.CONTINUOUS)  # number of 1-minute cinema ads

# Define the objective function
model.setObjective(80000*x1 + 30000*x2, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(9*x1 + 5*x2 >= 86, name="young_girls_constraint")
model.addConstr(4*x1 + 45*x2 >= 72, name="middle_aged_women_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Number of 1-minute concert ads: {x1.varValue}")
    print(f"Number of 1-minute cinema ads: {x2.varValue}")
    print(f"Minimum cost: ${model.objVal:.2f}")
else:
    print("The model is infeasible or unbounded.")
