
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Summer Painting Company")

# Create variables
students = m.addVar(lb=0, vtype=GRB.INTEGER, name="students")
full_time = m.addVar(lb=0, vtype=GRB.INTEGER, name="full_time")

# Set objective function
m.setObjective(200 * students + 500 * full_time, GRB.MINIMIZE)

# Add constraints
m.addConstr(students + full_time >= 100, "Total painters")
m.addConstr(full_time >= 30, "Minimum full-time")
m.addConstr(full_time >= 0.5 * students, "Experience ratio")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: ")
    print(f"Number of students: {students.x}")
    print(f"Number of full-time employees: {full_time.x}")
    print(f"Total wage bill: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

