
from gurobipy import *

# Create a new model
m = Model("Painting_Company")

# Define the variables
x1 = m.addVar(vtype=GRB.INTEGER, name="students")
x2 = m.addVar(vtype=GRB.INTEGER, name="full_time_employees")

# Set the objective function
m.setObjective(200*x1 + 500*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x2 >= 100, "total_painters")
m.addConstr(x2 >= 30, "full_time_min")
m.addConstr(x2 >= 0.5*x1, "experience_balance")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of students: {x1.x}")
    print(f"Number of full-time employees: {x2.x}")
    print(f"Total wage bill: ${200*x1.x + 500*x2.x}")
else:
    print("No optimal solution found")
