
import gurobi

def solve_painting_company_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="students")  # number of students
    x2 = model.addVar(lb=0, name="full_time_employees")  # number of full-time employees

    # Objective function: minimize the wage bill
    model.setObjective(200 * x1 + 500 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 + x2 >= 100, name="total_painters")
    model.addConstr(x2 >= 30, name="min_full_time_employees")
    model.addConstr(x2 >= 0.5 * x1, name="full_time_to_students_ratio")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Number of students: {x1.varValue}")
        print(f"Number of full-time employees: {x2.varValue}")
        print(f"Minimum wage bill: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_painting_company_problem()
