
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("rock_shop")

# Create variables
oval = m.addVar(vtype=GRB.INTEGER, name="oval")
rectangular = m.addVar(vtype=GRB.INTEGER, name="rectangular")

# Set objective function
m.setObjective(7 * oval + 9 * rectangular, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * oval + 15 * rectangular <= 2000, "washing_time")
m.addConstr(12 * oval + 12 * rectangular <= 2500, "polishing_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of oval rocks: {oval.x}")
    print(f"Number of rectangular rocks: {rectangular.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

