
from gurobipy import *

# Create a new model
m = Model("Rock_Collection")

# Add variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oval_rocks")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rectangular_rocks")

# Set the objective function
m.setObjective(7*x1 + 9*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 15*x2 <= 2000, "washing_time")
m.addConstr(12*x1 + 12*x2 <= 2500, "polishing_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oval rocks: {x1.x}")
    print(f"Rectangular rocks: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
