
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="oval_rocks", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="rectangular_rocks", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(7 * x1 + 9 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(10 * x1 + 15 * x2 <= 2000, name="washing_time")
    model.addConstr(12 * x1 + 12 * x2 <= 2500, name="polishing_time")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of oval rocks: {x1.varValue}")
        print(f"Number of rectangular rocks: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_problem()
