
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bubble_tea_optimization")

# Create variables
mango = m.addVar(lb=0, vtype=GRB.INTEGER, name="mango") # Number of mango drinks
peach = m.addVar(lb=0, vtype=GRB.INTEGER, name="peach") # Number of peach drinks


# Set objective function
m.setObjective(2 * mango + 3 * peach, GRB.MAXIMIZE)

# Add constraints
m.addConstr(mango + peach <= 150, "total_drinks")
m.addConstr(mango >= 60, "min_mango")
m.addConstr(peach >= 40, "min_peach")
m.addConstr(mango <= 120, "max_mango")
m.addConstr(peach <= 70, "max_peach")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of mango drinks: {mango.x}")
    print(f"Number of peach drinks: {peach.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

