
from gurobipy import *

# Create a new model
m = Model("Bubble_Tea_Optimization")

# Define variables
x1 = m.addVar(lb=60, ub=120, vtype=GRB.INTEGER, name="Mango_Drinks")
x2 = m.addVar(lb=40, ub=70, vtype=GRB.INTEGER, name="Peach_Drinks")

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 150, "Total_Drinks_Constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mango Drinks: {x1.x}")
    print(f"Peach Drinks: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
