
import gurobi

def solve_bubble_tea_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=120, name="mango_drinks")
    x2 = model.addVar(lb=0, ub=70, name="peach_drinks")

    # Objective function: Maximize 2*x1 + 3*x2
    model.setObjective(2*x1 + 3*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 150, name="total_drinks")
    model.addConstr(x1 >= 60, name="min_mango_drinks")
    model.addConstr(x2 >= 40, name="min_peach_drinks")
    model.addConstr(x1 <= 120, name="max_mango_drinks")
    model.addConstr(x2 <= 70, name="max_peach_drinks")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Mango drinks: {x1.varValue}")
        print(f"Peach drinks: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_bubble_tea_problem()
