
import gurobipy as gp

# Create a new model
m = gp.Model("Flower_Planting")

# Create variables
tulips = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tulips")
orchids = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="orchids")


# Set objective function
m.setObjective(75 * tulips + 105 * orchids, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(tulips + orchids <= 120, "Land_Constraint")
m.addConstr(15 * tulips + 40 * orchids <= 1200, "Budget_Constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {tulips.x} acres of tulips")
    print(f"Plant {orchids.x} acres of orchids")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

