
from gurobipy import *

# Create a new model
m = Model("Flower_Grower_Problem")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="acres_of_tulips")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="acres_of_orchids")

# Set the objective function
m.setObjective(75*x1 + 105*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 120, "total_acres")
m.addConstr(15*x1 + 40*x2 <= 1200, "seed_budget")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of tulips: {x1.x}")
    print(f"Acres of orchids: {x2.x}")
    print(f"Maximum profit: ${75*x1.x + 105*x2.x:.2f}")
else:
    print("No optimal solution found")
