
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="tulips", lb=0, ub=120)  # acres of tulips
    x2 = model.addVar(name="orchids", lb=0, ub=120)  # acres of orchids

    # Objective function: maximize 75*x1 + 105*x2
    model.setObjective(75*x1 + 105*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 120, name="land_constraint")
    model.addConstr(15*x1 + 40*x2 <= 1200, name="budget_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of tulips: {x1.varValue}")
        print(f"Optimal acres of orchids: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_optimization_problem()
