
import gurobipy as gp

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
corn = m.addVar(name="corn")
cabbage = m.addVar(name="cabbage")

# Set objective function
m.setObjective(50 * corn + 70 * cabbage, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(corn + cabbage <= 200, "land_constraint")
m.addConstr(corn + 1.5 * cabbage <= 200, "tractor_constraint")
m.addConstr(2 * corn + 3 * cabbage <= 275, "handpicking_constraint")
m.addConstr(corn >= 0, "corn_nonnegative")
m.addConstr(cabbage >= 0, "cabbage_nonnegative")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Acres of Corn: {corn.x}")
    print(f"Acres of Cabbage: {cabbage.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

