
from gurobipy import *

# Create a new model
m = Model("Farmer_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="acres_of_corn")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="acres_of_cabbage")

# Set objective function
m.setObjective(50*x1 + 70*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 1.5*x2 <= 200, "tractor_time_constraint")
m.addConstr(2*x1 + 3*x2 <= 275, "hand_picking_time_constraint")
m.addConstr(x1 + x2 <= 200, "total_land_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of corn: {x1.x}")
    print(f"Acres of cabbage: {x2.x}")
    print(f"Maximum profit: ${50*x1.x + 70*x2.x:.2f}")
else:
    print("No optimal solution found")
