
import gurobipy as gp

# Create a new model
model = gp.Model("Farmer_Problem")

# Define variables
x1 = model.addVar(name="corn_acres", lb=0, ub=200, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="cabbage_acres", lb=0, ub=200, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize profit
model.setObjective(50*x1 + 70*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 200, name="land_constraint")
model.addConstr(x1 + 1.5*x2 <= 200, name="tractor_constraint")
model.addConstr(2*x1 + 3*x2 <= 275, name="hand_picking_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of corn: {x1.varValue}")
    print(f"Optimal acres of cabbage: {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
