
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tshirt_sweater_optimization")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="t_shirts") # number of t-shirts
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="sweaters") # number of sweaters


# Set objective function
m.setObjective(15*x1 + 20*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 30*x2 <= 1000, "budget_constraint")
m.addConstr(x1 >= 20, "min_tshirts")
m.addConstr(x1 <= 40, "max_tshirts")
m.addConstr(x2 <= 0.5*x1, "sweater_tshirt_ratio")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of t-shirts: {x1.x}")
    print(f"Number of sweaters: {x2.x}")

