
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="t-shirts")  # number of t-shirts
    x2 = model.addVar(lb=0, name="sweaters")  # number of sweaters

    # Objective function: maximize profit
    model.setObjective(15*x1 + 20*x2, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(20*x1 + 30*x2 <= 1000, name="budget_constraint")

    # T-shirt sales constraints
    model.addConstr(x1 >= 20, name="min_tshirts_constraint")
    model.addConstr(x1 <= 40, name="max_tshirts_constraint")

    # Sweater sales constraint
    model.addConstr(x2 <= 0.5*x1, name="sweater_tshirt_ratio_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of t-shirts: {x1.varValue}")
        print(f"Number of sweaters: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
