
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("maple_production")

# Create variables
maple_syrup = m.addVar(name="maple_syrup")
maple_candy = m.addVar(name="maple_candy")

# Set objective function
m.setObjective(20 * maple_syrup + 15 * maple_candy, GRB.MAXIMIZE)

# Add constraints
m.addConstr(maple_syrup <= 10, "max_syrup")
m.addConstr(maple_candy <= 12, "max_candy")
m.addConstr(maple_syrup >= 3, "min_syrup")
m.addConstr(maple_candy >= 5, "min_candy")
m.addConstr(2 * maple_syrup + 2 * maple_candy <= 20, "boiling_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Maple syrup production: {maple_syrup.x:.2f} kg")
    print(f"Maple candy production: {maple_candy.x:.2f} kg")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

