
from gurobipy import *

# Create a new model
m = Model("Maple_Farm_Profit")

# Add variables
x1 = m.addVar(name="maple_syrup", lb=3, ub=10)  # Amount of maple syrup (kg)
x2 = m.addVar(name="maple_candy", lb=5, ub=12)  # Amount of maple candy (kg)

# Set the objective function
m.setObjective(20*x1 + 15*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 10, name="max_syrup")
m.addConstr(x2 <= 12, name="max_candy")
m.addConstr(2*x1 + 2*x2 <= 20, name="boiling_station_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Maple Syrup: {x1.x} kg")
    print(f"Maple Candy: {x2.x} kg")
    print(f"Maximum Profit: ${m.objVal}")
else:
    print("No optimal solution found.")
