
import gurobipy as gp

# Create a new model
model = gp.Model("MapleFarm")

# Define variables
x1 = model.addVar(lb=3, ub=10, name="maple_syrup")  # kg
x2 = model.addVar(lb=5, ub=12, name="maple_candy")  # kg

# Objective function: maximize profit
model.setObjective(20*x1 + 15*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 <= 10, name="syrup_limit")
model.addConstr(x2 <= 12, name="candy_limit")
model.addConstr(x1 >= 3, name="syrup_min")
model.addConstr(x2 >= 5, name="candy_min")
model.addConstr(2*x1 + 2*x2 <= 20, name="boiling_station_limit")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal amount of maple syrup: {x1.varValue} kg")
    print(f"Optimal amount of maple candy: {x2.varValue} kg")
    print(f"Maximal profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
