
import gurobipy as gp

# Create a new model
model = gp.Model("Taco_Restaurant")

# Create decision variables
burritos = model.addVar(vtype=gp.GRB.CONTINUOUS, name="burritos")
tacos = model.addVar(vtype=gp.GRB.CONTINUOUS, name="tacos")


# Set objective function
model.setObjective(3 * burritos + 3.5 * tacos, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4 * burritos + 4.5 * tacos <= 500, "beef_constraint")
model.addConstr(4 * burritos + 3 * tacos <= 400, "toppings_constraint")
model.addConstr(burritos >= 0, "burritos_nonnegative")
model.addConstr(tacos >= 0, "tacos_nonnegative")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of burritos: {burritos.x}")
    print(f"Number of tacos: {tacos.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

