
from gurobipy import *

# Create a new model
m = Model("Taco_Restaurant")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="burritos")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="tacos")

# Set the objective function
m.setObjective(3*x1 + 3.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 4.5*x2 <= 500, "beef_limit")
m.addConstr(4*x1 + 3*x2 <= 400, "toppings_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Burritos to sell: {x1.x}")
    print(f"Tacos to sell: {x2.x}")
    print(f"Maximum profit: ${3*x1.x + 3.5*x2.x:.2f}")
else:
    print("No optimal solution found")
