
import gurobi

def solve_taco_restaurant_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="burritos", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="tacos", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(3 * x1 + 3.5 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * x1 + 4.5 * x2 <= 500, name="beef_constraint")
    model.addConstr(4 * x1 + 3 * x2 <= 400, name="toppings_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Max profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible")

solve_taco_restaurant_problem()
