
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("restaurant_staffing")

# Create variables
waiters = m.addVar(lb=0, vtype=GRB.INTEGER, name="waiters")
cooks = m.addVar(lb=0, vtype=GRB.INTEGER, name="cooks")

# Set objective function
m.setObjective(147 * waiters + 290 * cooks, GRB.MINIMIZE)

# Add constraints
m.addConstr(147 * waiters + 290 * cooks <= 17600, "wage_bill")
m.addConstr(waiters + cooks >= 50, "min_staff")
m.addConstr(cooks >= 12, "min_cooks")
m.addConstr(cooks >= (1/3) * waiters, "cook_waiter_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Number of waiters: {waiters.x}")
    print(f"Number of cooks: {cooks.x}")
    print(f"Total wage bill: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

