
from gurobipy import *

# Create a new model
m = Model("Restaurant_Staffing")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="waiters")
x2 = m.addVar(vtype=GRB.INTEGER, name="cooks")

# Set the objective function
m.setObjective(147*x1 + 290*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(147*x1 + 290*x2 <= 17600, "wage_bill")
m.addConstr(x1 + x2 >= 50, "total_staff")
m.addConstr(x2 >= 12, "min_cooks")
m.addConstr(x2 >= (1/3)*x1, "union_regulations")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of waiters: {x1.x}")
    print(f"Number of cooks: {x2.x}")
    print(f"Total wage bill: ${147*x1.x + 290*x2.x:.2f}")
else:
    print("No optimal solution found")
