
import gurobi

def solve_restaurant_staffing_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='waiters', lb=0, vtype=gurobi.GRB.INTEGER)  # Number of waiters
    x2 = model.addVar(name='cooks', lb=0, vtype=gurobi.GRB.INTEGER)    # Number of cooks

    # Set the objective function
    model.setObjective(147 * x1 + 290 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 >= 50, name='total_staff')
    model.addConstr(x2 >= 12, name='min_cooks')
    model.addConstr(x2 >= (1/3) * x1, name='cook_to_waiter_ratio')
    model.addConstr(147 * x1 + 290 * x2 <= 17600, name='wage_bill')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal Solution:')
        print(f'Number of waiters: {x1.varValue}')
        print(f'Number of cooks: {x2.varValue}')
        print(f'Total wage bill: ${147 * x1.varValue + 290 * x2.varValue}')
    else:
        print('No optimal solution found.')

solve_restaurant_staffing_problem()
