
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("pants_production")

# Create variables
grey_pants = m.addVar(vtype=GRB.CONTINUOUS, name="grey_pants")  # Number of grey pants
black_pants = m.addVar(vtype=GRB.CONTINUOUS, name="black_pants") # Number of black pants

# Set objective function: Maximize profit
m.setObjective(25 * grey_pants + 15 * black_pants, GRB.MAXIMIZE)

# Add constraints
m.addConstr(40 * grey_pants + 20 * black_pants <= 2100, "Wimo_constraint") # Wimo time constraint
m.addConstr(30 * grey_pants + 15 * black_pants <= 3000, "Webo_constraint") # Webo time constraint
m.addConstr(grey_pants >= 0, "grey_pants_nonneg") # Non-negativity constraint
m.addConstr(black_pants >= 0, "black_pants_nonneg") # Non-negativity constraint


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Grey Pants: {grey_pants.x}")
    print(f"Number of Black Pants: {black_pants.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

