
from gurobipy import *

# Create a model
m = Model("Clothing_Company_Profit")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="grey_pants", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="black_pants", lb=0)

# Objective function: Maximize profit
m.setObjective(25*x1 + 15*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(40*x1 + 20*x2 <= 2100, "Wimo_Time")
m.addConstr(30*x1 + 15*x2 <= 3000, "Webo_Time")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grey Pants: {x1.x}")
    print(f"Black Pants: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
