
import gurobipy as gp

# Create a new model
model = gp.Model("Pants_Production")

# Define the variables
x1 = model.addVar(name="grey_pants", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="black_pants", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(25*x1 + 15*x2, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(40*x1 + 20*x2 <= 2100, name="Wimo_constraint")
model.addConstr(30*x1 + 15*x2 <= 3000, name="Webo_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Number of grey pants: {x1.varValue}")
    print(f"Number of black pants: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
