
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Car_Oil_Production")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Regular_Synthetic") # Regular Synthetic
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Premium_Synthetic") # Premium Synthetic


# Set objective function
m.setObjective(17.4 * x1 + 11.1 * x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25 * x1 + 10 * x2 <= 1000, "Substance_A")
m.addConstr(40 * x1 + 25 * x2 <= 500, "Substance_B")
m.addConstr(36 * x1 + 40 * x2 <= 900, "Substance_C")
m.addConstr(x1 >= 0, "NonNegativity_x1")
m.addConstr(x2 >= 0, "NonNegativity_x2")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Regular Synthetic: {x1.x:.2f} containers")
    print(f"Premium Synthetic: {x2.x:.2f} containers")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

