
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="Regular_Synthetic", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="Premium_Synthetic", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(17.4 * x1 + 11.1 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(25 * x1 + 10 * x2 <= 1000, name="Substance_A")
    model.addConstr(40 * x1 + 25 * x2 <= 500, name="Substance_B")
    model.addConstr(36 * x1 + 40 * x2 <= 900, name="Substance_C")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Containers of Regular Synthetic: {x1.varValue}")
        print(f"Containers of Premium Synthetic: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
