
import gurobipy as gp

# Create a new model
m = gp.Model("furniture_production")

# Create variables
chairs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chairs")
shelves = m.addVar(vtype=gp.GRB.CONTINUOUS, name="shelves")

# Set objective function
m.setObjective(50 * chairs + 55 * shelves, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * chairs + 20 * shelves <= 3000, "assembly_time")
m.addConstr(50 * chairs + 60 * shelves <= 4000, "painting_time")
m.addConstr(chairs >= 0, "chairs_nonnegative")
m.addConstr(shelves >= 0, "shelves_nonnegative")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of chairs to produce: {chairs.x}")
    print(f"Number of shelves to produce: {shelves.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

