
from gurobipy import *

# Create a new model
m = Model("Furniture_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="chairs")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="shelves")

# Set the objective function
m.setObjective(50*x1 + 55*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 20*x2 <= 3000, "assembly_time")
m.addConstr(50*x1 + 60*x2 <= 4000, "painting_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
