
import gurobipy as gp

def solve_furniture_problem():
    # Create a new model
    model = gp.Model("furniture_problem")

    # Define variables
    x1 = model.addVar(name="chairs", lb=0, vtype=gp.GRB.CONTINUOUS)
    x2 = model.addVar(name="shelves", lb=0, vtype=gp.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(50*x1 + 55*x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(30*x1 + 20*x2 <= 3000, name="assembly_time")
    model.addConstr(50*x1 + 60*x2 <= 4000, name="painting_time")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution: chairs = {x1.varValue}, shelves = {x2.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_furniture_problem()
